//****** Klassendefinitionen *******
function SimpleTimer() {
	this.valueHours=0;
	this.valueMinutes=0;
	this.valueSeconds=0;
	this.timerVal = "";
	
	this.isRunning = false;	
	this.intervalID;
	this.invisibleMode=false;
	
	this.init = function () {
		this.updateDisplay();
	}
	
	this.mouseDown = function (event, id) {
		
		event.target.src = "Images/" + id + "_pressed.png";
		this.buttonPress( id );
		
		event.stopPropagation();
		event.preventDefault();
	}
	
	this.mouseUp = function (event, id) {
		
		event.target.src = "Images/" + id + "_idle.png";
	}
	
	this.keyPressed = function ( event ) {
	}
	
	this.keyReleased = function ( event ) {
	}
	
	this.buttonPress = function (id) {
		switch ( id ) {
			case "button_left":
				clearInterval(this.intervalID);
				break;
			case "button_right":
				if(this.valueHours>0||this.valueMinutes>0||this.valueSeconds>0)
				{
				this.doTiming();
				}
				break;
		}
	}
	
	this.doTiming = function () {
		this.isRunning = true;		

		var desHours = this.valueHours * 3600000;
		var desMin = this.valueMinutes * 60000;
		var desSec = this.valueSeconds * 1000;
		
		var desDateTime = new Date().getTime();
		desDateTime+=desHours+desMin+desSec;
		
		window.clearInterval(this.intervalID);
		this.intervalID = window.setInterval("t.runTimer( " + desDateTime + " )",150);
	}

	this.runTimer = function ( desDateTime ) {
		
		var actDateTime = new Date().getTime();
		
		timeVar = desDateTime - actDateTime;
				
		if(timeVar >= 0) {
		
			if ( !this.invisibleMode ) {
				
				var	hoursRest = timeVar % 3600000;
				this.valueHours = (timeVar - hoursRest) / 3600000;
				
				var minsRest = hoursRest % 60000;
				this.valueMinutes = (hoursRest - minsRest) / 60000;
				
				this.valueSeconds = Math.floor(minsRest / 1000);
				
				this.updateDisplay();
				}
				
			} else {
				this.isRunning = false;
				window.clearInterval(this.intervalID);
				
				this.setTime(0,0,0);
				this.updateDisplay();

				if(window.widget) {
					this.showNotification();
				}
			}
	}
	
	this.showNotification = function() {
		DialogPlugin.displayDialogW(this.timerVal);
	}
	
	this.updateDisplay = function () {

		displayHours1 = document.getElementById("timerTimeHours1");
		displayHours2 = document.getElementById("timerTimeHours2");

		displayMinutes1 = document.getElementById("timerTimeMinutes1");
		displayMinutes2 = document.getElementById("timerTimeMinutes2");

		displaySeconds1 = document.getElementById("timerTimeSeconds1");
		displaySeconds2 = document.getElementById("timerTimeSeconds2");

		displayHoursDevider = document.getElementById("timerTimeHoursDevider");
		displayMinutesDevider = document.getElementById("timerTimeMinutesDevider");
		
		timePanel = document.getElementById("timePanel");
		
		timerVal =	document.getElementById("timerWhat");

		timerVal.firstChild.data = this.timerVal;
		
		displayHoursDevider.firstChild.data = ":";
		displayMinutesDevider.firstChild.data = ":";
		
		var strHours = new String(this.valueHours);
		var strMinutes = new String(this.valueMinutes);
		var strSeconds = new String(this.valueSeconds);
		
		displayHours1.firstChild.data = ((this.valueHours < 10) ? 0 : strHours.substr(0,1));
		displayHours2.firstChild.data = ((this.valueHours < 10) ? this.valueHours : strHours.substr(1,1));
		
		displayMinutes1.firstChild.data = ((this.valueMinutes < 10) ? 0 : strMinutes.substr(0,1));
		displayMinutes2.firstChild.data = ((this.valueMinutes < 10) ? this.valueMinutes : strMinutes.substr(1,1));
		
		displaySeconds1.firstChild.data = ((this.valueSeconds < 10) ? 0 : strSeconds.substr(0,1));
		displaySeconds2.firstChild.data = ((this.valueSeconds < 10) ? this.valueSeconds : strSeconds.substr(1,1));
		
		displayHours1.style.left = 0 + (15-this.getElementWidth(displayHours1)) / 1 + "px";
		displayHours2.style.left = 15 + (15-this.getElementWidth(displayHours2)) / 1 + "px";
		
		displayHoursDevider.style.left = 25 + this.getElementWidth(displayHoursDevider) / 2 + "px";
		
		displayMinutes1.style.left = 36 + (15-this.getElementWidth(displayMinutes1)) / 1 + "px";
		displayMinutes2.style.left = 51 + (15-this.getElementWidth(displayMinutes2)) / 1 + "px";

		displayMinutesDevider.style.left = 60 + this.getElementWidth(displayMinutesDevider) / 2 + "px";

		displaySeconds1.style.left = 71 + (15-this.getElementWidth(displaySeconds1)) / 1 + "px";
		displaySeconds2.style.left = 86 + (15-this.getElementWidth(displaySeconds2)) / 1 + "px";
		
		timePanel.style.left = "72px";
		timePanel.style.top = "30px";
	}
	
	this.getElementWidth = function ( element ) {
		var computedStyle = document.defaultView.getComputedStyle(element,'');        
    	elementWidth = parseInt(computedStyle.getPropertyValue("width"));
    	return elementWidth;
	}
	
	this.setTime = function ( h, m, s) {
		this.isRunning = false;
		window.clearInterval(this.intervalID);
		
		this.valueHours = h;
		this.valueMinutes = m;
		this.valueSeconds = s;
	}
	
	this.stopTimer = function () {
		this.isRunning = false;
		window.clearInterval(this.intervalID);
		}
	
	this.resetTimer = function () {
	
	if(this.isRunning) {
			this.isRunning = false;
			window.clearInterval(this.intervalID);
			this.setTime(0,0,0);
			this.updateDisplay();
		} else {
			this.setTime(0,0,0);
			this.updateDisplay();
		}	
	}
	
	
}

//******************
//Start der Routinen
//******************
if(DialogPlugin) {
	DialogPlugin.logMessage("OK - Hier aus dem TimerWidget");
	}

if (window.widget) {
	widget.onhide = onhide;
	widget.onshow = onshow;
}

function onshow() {
	t.invisibleMode = false;
}

function onhide() {
	t.invisibleMode = true;
}	



function goSpiewok(event)
{
	if(window.widget) {
		widget.openURL("http://www.spiewok.de");
	}
}

// Ab hier Apple Code zum Darstellen des Hintergrundes (Auerhalb der Timerklasse).

function showBack()
{
    window.resizeTo(500,500);

    var front = document.getElementById("front");
    var back = document.getElementById("back");

    t.stopTimer();
    
	document.getElementById("inputHours").value = t.valueHours;
	document.getElementById("inputMinutes").value = t.valueMinutes;
	document.getElementById("inputSeconds").value = t.valueSeconds;
	document.getElementById("timerVal").value = t.timerVal;
    
    if (window.widget)
        widget.prepareForTransition("ToBack");
                
    front.style.display="none";
	document.getElementById('fliprollie').style.display = 'none';

	back.style.display="block";	
    
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);         
}

function hideBack()
{

    var front = document.getElementById("front");
    var back = document.getElementById("back");
            
    if (window.widget)
        widget.prepareForTransition("ToFront");
                
    back.style.display="none";
    front.style.display="block";


	t.setTime(Number(document.getElementById("inputHours").value),Number(document.getElementById("inputMinutes").value),Number(document.getElementById("inputSeconds").value));
	t.timerVal = document.getElementById("timerVal").value;
	t.updateDisplay();
    
    document.getElementById('fliprollie').style.display = 'none';
    
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);

	window.resizeTo(245,65);
}

var resizeTimer;
function resizeMe(x,y) {
}

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};
function mousemove (event)
{
    if (!flipShown)
    {
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 1.0;
        animate();
        flipShown = true;
    }
}
function mouseexit (event)
{
    if (flipShown)
    {
        // fade in the info button
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 0.0;
        animate();
        flipShown = false;
    }
}
function animate()
{
    var T;
    var ease;
    var time = (new Date).getTime();
                
        
    T = limit_3(time-animation.starttime, 0, animation.duration);
        
    if (T >= animation.duration)
    {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    }
    else
    {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
        
    animation.firstElement.style.opacity = animation.now;
}
function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function enterflip(event)
{
    document.getElementById('fliprollie').style.display = 'block';
}
function exitflip(event)
{
    document.getElementById('fliprollie').style.display = 'none';
}

function hinweisGezeigt() {
}

function doKeyPress (event)
{
}


